package app.firezone.synk.network.Adapter;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import app.firezone.synk.network.R;
import app.firezone.synk.network.databinding.WinnerLayoutBinding;
import app.firezone.synk.network.model.Winner_Model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class BgmiWinnerAdapter extends RecyclerView.Adapter<BgmiWinnerAdapter.holder> {
    Context mContext;
    ArrayList<Winner_Model> mlist;

    public BgmiWinnerAdapter(ArrayList<Winner_Model> mlist, Context mContext){
        this.mlist = mlist;
        this.mContext = mContext;

        Collections.sort(this.mlist, new Comparator<Winner_Model>() {
            @Override
            public int compare(Winner_Model w1, Winner_Model w2) {
                return Integer.compare(Integer.parseInt(w2.getPrize()), Integer.parseInt(w1.getPrize())); // Descending order
            }
        });

    }

    @NonNull
    @Override
    public holder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from(mContext).inflate(R.layout.winner_layout,parent,false);
        return new holder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull holder holder, @SuppressLint("RecyclerView") int position) {

        Winner_Model model = mlist.get(position);


        holder.binding.winnerKills.setText(model.getKill());
        holder.binding.winnerName.setText(model.getUsername());
        holder.binding.winnerPrize.setText("₹" +model.getPrize());

        int reversePosition = position + 1; // Serial number starts from 1
        holder.binding.winnerNo.setText(String.valueOf(reversePosition));

    }

    @Override
    public int getItemCount() {
        return mlist.size();
    }

    public class holder extends RecyclerView.ViewHolder {

        WinnerLayoutBinding binding;

        public holder(@NonNull View itemView) {
            super(itemView);
            binding = WinnerLayoutBinding.bind(itemView);
        }
    }
}
